/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
//import net.sinodawn.framework.support.matrix.service.GenericMatrixService;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import java.util.List;

public interface CoreRoleUserService extends GenericService<CoreRoleUserBean, Long> {
   Long insertByUserId(String userId, List<Long> roleIdList);

   void deleteByUserId(String userId, List<Long> roleIdList);

   void deleteByUserId(String userId);

   void deleteByRoleId(Long roleId);

   List<CoreRoleUserBean> selectByUserId(String userId);

   List<String> selectUserList(Long roleId);

   Page<CoreRoleUserBean> selectPaginationByRole(Long roleId, RestJsonWrapperBean wrapper);

   void setDefault(String userId, RestJsonWrapperBean wrapper);
}
