/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.support.table.bean.TableHeadBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;

import java.util.List;

public interface CoreRoleService extends GenericService<CoreRoleBean, Long> {
   Long insert(RestJsonWrapperBean wrapper);

   Page<CoreRoleUserBean> selectRoleUserPaginationByRole(Long roleId, RestJsonWrapperBean wrapper);

   void insertRoleUser(Long id, RestJsonWrapperBean wrapper);

   void deleteRoleUser(RestJsonWrapperBean wrapper);

   void insertRolePermission(Long id, String permissionTypeId, RestJsonWrapperBean wrapper);

   void deleteRolePermission(Long id, String permissionTypeId, RestJsonWrapperBean wrapper);

   boolean isPermissionTypeAdminRole(Long roleId, String permissionTypeId);

   List<TableHeadBean> selectPermissionMatrixHeadList();

   RestValidationResultBean deleteValidate(RestJsonWrapperBean wrapper);
}
