/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.service;

import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.role.bean.CoreRolePermissionBean;
import java.util.List;

public interface CoreRolePermissionService extends GenericService<CoreRolePermissionBean, Long> {
   List<CoreRolePermissionBean> selectListByRole(Long roleId);

   void insert(Long roleId, String permissionTypeId, List<String> targetIdList);

   void delete(Long roleId, String permissionTypeId, List<String> targetIdList);

   void deleteByRoleId(Long roleId);

   List<CoreRolePermissionBean> selectActiveUserPermissionList(String userId, String permissionType);

   String selectPermissionTypeAdmin(String permisionTypeId);
}
