/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.resource.impl;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.role.resource.CoreRoleUserResource;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@LogModule("角色用户")
@RestController
public class CoreRoleUserResourceImpl implements CoreRoleUserResource {
   @Autowired
   private CoreRoleUserService roleUserService;

   public CoreRoleUserService getService() {
      return this.roleUserService;
   }

   public CoreRoleUserService getMatrixService() {
      return this.roleUserService;
   }

   @Log(
      value = "设置默认角色",
      type = LogType.UPDATE
   )
   public void setDefault(@PathVariable String userId, RestJsonWrapperBean wrapper) {
      this.getService().setDefault(userId, wrapper);
   }
}
