/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import net.sinodawn.framework.support.table.bean.TableHeadBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.resource.CoreRoleResource;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@LogModule("角色")
@RestController
public class CoreRoleResourceImpl implements CoreRoleResource {
   @Autowired
   private CoreRoleService roleService;

   public CoreRoleService getService() {
      return this.roleService;
   }

   @Log(
      value = "新增角色",
      type = LogType.INSERT
   )
   public Long insert(RestJsonWrapperBean wrapper) {
      return this.getService().insert(wrapper);
   }

   @Log(
      value = "通过角色来查询所属用户",
      type = LogType.SELECT
   )
   public Page<CoreRoleUserBean> selectRoleUserPaginationByRole(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      return this.getService().selectRoleUserPaginationByRole(id, wrapper);
   }

   @Log(
      value = "新增角色用户",
      type = LogType.INSERT
   )
   public void insertRoleUser(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().insertRoleUser(id, wrapper);
   }

   @Log(
      value = "删除角色用户",
      type = LogType.DELETE
   )
   public void deleteRoleUser(RestJsonWrapperBean wrapper) {
      this.getService().deleteRoleUser(wrapper);
   }

   @Log(
      value = "指定角色下新增指定类型的权限",
      type = LogType.INSERT
   )
   public void insertRolePermission(@PathVariable Long id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper) {
      this.getService().insertRolePermission(id, permissionTypeId, wrapper);
   }

   @Log(
      value = "指定角色下删除指定类型下的权限",
      type = LogType.INSERT
   )
   public void deleteRolePermission(@PathVariable Long id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper) {
      this.getService().deleteRolePermission(id, permissionTypeId, wrapper);
   }

   @Log(
      value = "验证角色是否是指定类型权限的管理员",
      type = LogType.INSERT
   )
   public boolean isPermissionTypeAdminRole(@PathVariable Long id, @PathVariable String permissionTypeId) {
      return this.getService().isPermissionTypeAdminRole(id, permissionTypeId);
   }

   @Log(
      value = "查询角色用户权限标题",
      type = LogType.SELECT
   )
   public List<TableHeadBean> selectPermissionMatrixHeadList() {
      return this.getService().selectPermissionMatrixHeadList();
   }

   @Log(
      value = "角色删除校验",
      type = LogType.VALIDATE
   )
   public RestValidationResultBean deleteValidate(RestJsonWrapperBean wrapper) {
      return this.getService().deleteValidate(wrapper);
   }
}
