/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.resource.impl;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.module.sys.role.resource.CoreRolePermissionResource;
import net.sinodawn.module.sys.role.service.CoreRolePermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@LogModule("角色权限")
@RestController
public class CoreRolePermissionResourceImpl implements CoreRolePermissionResource {
   @Autowired
   private CoreRolePermissionService permissionService;

   public CoreRolePermissionService getService() {
      return this.permissionService;
   }

   @Log(
      value = "查询当前登录用户是否为权限类型管理员",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/permision-type-admin/{permisionTypeId}"},
      method = {RequestMethod.GET}
   )
   public String selectPermissionTypeAdmin(@PathVariable String permisionTypeId) {
      return this.getService().selectPermissionTypeAdmin(permisionTypeId);
   }
}
