/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.framework.support.table.bean.TableHeadBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@RequestMapping({"/secure/core/module/sys/roles"})
public interface CoreRoleResource extends GenericResource<CoreRoleService, CoreRoleBean, Long> {
   @RequestMapping(
      method = {RequestMethod.POST}
   )
   Long insert(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/role-users/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreRoleUserBean> selectRoleUserPaginationByRole(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/role-users"},
      method = {RequestMethod.POST}
   )
   void insertRoleUser(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/role-users"},
      method = {RequestMethod.DELETE}
   )
   void deleteRoleUser(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/role-permission-types/{permissionTypeId}/role-permissions"},
      method = {RequestMethod.POST}
   )
   void insertRolePermission(@PathVariable Long id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/role-permission-types/{permissionTypeId}/role-permissions"},
      method = {RequestMethod.DELETE}
   )
   void deleteRolePermission(@PathVariable Long id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/role-permission-types/{permissionTypeId}/action/validate-admin"},
      method = {RequestMethod.GET}
   )
   boolean isPermissionTypeAdminRole(@PathVariable Long id, @PathVariable String permissionTypeId);

   @RequestMapping(
      value = {"/permission-matrices/heads/queries"},
      method = {RequestMethod.POST}
   )
   List<TableHeadBean> selectPermissionMatrixHeadList();

   @RequestMapping(
      value = {"/action/delete-validate"},
      method = {RequestMethod.POST}
   )
   RestValidationResultBean deleteValidate(RestJsonWrapperBean wrapper);
}
