/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.dao.impl;

import net.sinodawn.framework.mybatis.dao.MybatisDaoSupport;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.dao.CoreRoleDao;
import net.sinodawn.module.sys.role.mapper.CoreRoleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

@Repository
public class CoreRoleDaoImpl extends MybatisDaoSupport<CoreRoleBean, Long> implements CoreRoleDao {
   @Autowired
   private CoreRoleMapper mapper;

   public CoreRoleMapper getMapper() {
      return this.mapper;
   }

   @Cacheable(
      value = {"T_CORE_ROLE"},
      key = "'' + #id",
      unless = "#result == null"
   )
   public CoreRoleBean selectByIdIfPresent(Long id) {
      return (CoreRoleBean)super.selectByIdIfPresent(id);
   }

   @CacheEvict(
      value = {"T_CORE_ROLE"},
      keyGenerator = "defaultDaoCacheEvictKeyGenerator"
   )
   public void cacheEvict(CoreRoleBean oldItem, CoreRoleBean newItem) {
   }
}
