/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.bean;

import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;

@Table("T_CORE_ROLE_USER")
public class CoreRoleUserBean extends AbstractInsertable<Long> implements Insertable<Long> {
   @Transient
   private static final long serialVersionUID = 918783712976163930L;
   @Id
   private Long id;
   private Long roleId;
   private String userId;
   @NotNull(
      defaultValue = "0"
   )
   private String defaultFlag;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public Long getRoleId() {
      return this.roleId;
   }

   public void setRoleId(Long roleId) {
      this.roleId = roleId;
   }

   public String getUserId() {
      return this.userId;
   }

   public void setUserId(String userId) {
      this.userId = userId;
   }

   public String getDefaultFlag() {
      return this.defaultFlag;
   }

   public void setDefaultFlag(String defaultFlag) {
      this.defaultFlag = defaultFlag;
   }
}
