/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.role.bean;

import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import net.sinodawn.framework.support.domain.Orderable;
import net.sinodawn.framework.support.domain.Suspendable;
import java.time.LocalDateTime;

@Table("T_CORE_ROLE")
public class CoreRoleBean extends AbstractInsertable<Long> implements Insertable<Long>, Suspendable<Long>, Orderable<Long> {
   @Transient
   private static final long serialVersionUID = 2727145737862448451L;
   @Id
   private Long id;
   private String roleName;
   private String usedByOrgId;
   private String usedByOrgName;
   private String roleDesc;
   private Long passwordPolicyId;
   private Long orderNo;
   @NotNull(
      defaultValue = "0"
   )
   private String lastSuspendedFlag;
   private String lastSuspendedById;
   private String lastSuspendedByName;
   private LocalDateTime lastSuspendedTime;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getRoleName() {
      return this.roleName;
   }

   public void setRoleName(String roleName) {
      this.roleName = roleName;
   }

   public String getUsedByOrgId() {
      return this.usedByOrgId;
   }

   public void setUsedByOrgId(String usedByOrgId) {
      this.usedByOrgId = usedByOrgId;
   }

   public String getUsedByOrgName() {
      return this.usedByOrgName;
   }

   public void setUsedByOrgName(String usedByOrgName) {
      this.usedByOrgName = usedByOrgName;
   }

   public String getRoleDesc() {
      return this.roleDesc;
   }

   public void setRoleDesc(String roleDesc) {
      this.roleDesc = roleDesc;
   }

   public Long getOrderNo() {
      return this.orderNo;
   }

   public void setOrderNo(Long orderNo) {
      this.orderNo = orderNo;
   }

   public Long getPasswordPolicyId() {
      return this.passwordPolicyId;
   }

   public void setPasswordPolicyId(Long passwordPolicyId) {
      this.passwordPolicyId = passwordPolicyId;
   }

   public String getLastSuspendedFlag() {
      return this.lastSuspendedFlag;
   }

   public void setLastSuspendedFlag(String lastSuspendedFlag) {
      this.lastSuspendedFlag = lastSuspendedFlag;
   }

   public String getLastSuspendedById() {
      return this.lastSuspendedById;
   }

   public void setLastSuspendedById(String lastSuspendedById) {
      this.lastSuspendedById = lastSuspendedById;
   }

   public String getLastSuspendedByName() {
      return this.lastSuspendedByName;
   }

   public void setLastSuspendedByName(String lastSuspendedByName) {
      this.lastSuspendedByName = lastSuspendedByName;
   }

   public LocalDateTime getLastSuspendedTime() {
      return this.lastSuspendedTime;
   }

   public void setLastSuspendedTime(LocalDateTime lastSuspendedTime) {
      this.lastSuspendedTime = lastSuspendedTime;
   }
}
