/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.password.validator;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.data.DataValidator;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class CorePasswordPolicyDeleteValidator implements DataValidator {
   @Autowired
   @Lazy
   private CoreRoleService coreRoleService;

   public boolean doValid(Object... args) {
      RestJsonWrapperBean wrapper = (RestJsonWrapperBean)args[0];
      List<Long> idList = (List)wrapper.parse(CorePasswordPolicyBean.class).stream().map((e) -> {
         return e.getId();
      }).collect(Collectors.toList());
      List<CoreRoleBean> coreRoleList = this.coreRoleService.getDao().selectListByOneColumnValues(idList, "PASSWORDPOLICYID");
      boolean validFlag = true;
      if (!coreRoleList.isEmpty()) {
         this.addConstraintViolation("CORE.MODULE.SYS.PASSWORDS.VALIDATTION.CAN_NOT_DELETE");
         validFlag = false;
      }

      return validFlag;
   }
}
