/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.password.service;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;

import java.util.List;

public interface CorePasswordPolicyService extends GenericService<CorePasswordPolicyBean, Long> {
   Long insert(RestJsonWrapperBean jsonWrapper);

   List<CorePasswordPolicyBean> selectEffectedList(String userId);

   void checkPassword(String userId, String password);

   CorePasswordPolicyBean selectMatchingPasswordPolicy();

   CorePasswordPolicyBean selectMatchingPasswordPolicy(String userId);

   Long selectPasswordExpireRemainingDays();

   Long selectPasswordExpireRemainingDays(List<CorePasswordPolicyBean> passwordPolicyList);

   Long selectPasswordExpiredMaxUse(List<CorePasswordPolicyBean> passwordPolicyList);
}
