/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.password.resource.impl;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.data.annotation.ValidateDataWith;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.password.resource.CorePasswordPolicyResource;
import net.sinodawn.module.sys.password.service.CorePasswordPolicyService;
import net.sinodawn.module.sys.password.validator.CorePasswordPolicyDeleteValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@LogModule("密码策略")
@RestController
public class CorePasswordPolicyResourceImpl implements CorePasswordPolicyResource {
   @Autowired
   private CorePasswordPolicyService policyService;

   public CorePasswordPolicyService getService() {
      return this.policyService;
   }

   public Long insert(RestJsonWrapperBean jsonWrapper) {
      return this.getService().insert(jsonWrapper);
   }

   @ValidateDataWith(CorePasswordPolicyDeleteValidator.class)
   public void delete(RestJsonWrapperBean wrapper) {
      this.getService().delete(wrapper);
   }

   @Log(
      value = "获取匹配当前用户的秘密策略",
      type = LogType.SELECT
   )
   public CorePasswordPolicyBean selectMatchingPasswordPolicy() {
      return this.getService().selectMatchingPasswordPolicy();
   }
}
