/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.password.bean;

import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Suspendable;
import org.springframework.data.annotation.Id;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_PASSWORD_POLICY")
public class CorePasswordPolicyBean extends AbstractPersistable<Long> implements Suspendable<Long> {
   private static final long serialVersionUID = -1985232084471259933L;
   @Id
   private Long id;
   private String name;
   private String type;
   private Long minNumber;
   private Long minLowercase;
   private Long minUppercase;
   private Long minSpecialCharacters;
   private Long minLength;
   private Long maxLength;
   private Long composition;
   private Long maxFailedAttempts;
   private Long expiryInterval;
   private Long expiryWarningInterval;
   private Long expiredMaxUse;
   private Long reuseInterval;
   private Long historyLength;
   @NotNull(
      defaultValue = "0"
   )
   private String lastSuspendedFlag;
   private String lastSuspendedById;
   private String lastSuspendedByName;
   @JSONField(
      format = "yyyy-MM-dd"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime lastSuspendedTime;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public Long getMinNumber() {
      return this.minNumber;
   }

   public void setMinNumber(Long minNumber) {
      this.minNumber = minNumber;
   }

   public Long getMinLowercase() {
      return this.minLowercase;
   }

   public void setMinLowercase(Long minLowercase) {
      this.minLowercase = minLowercase;
   }

   public Long getMinUppercase() {
      return this.minUppercase;
   }

   public void setMinUppercase(Long minUppercase) {
      this.minUppercase = minUppercase;
   }

   public Long getMinSpecialCharacters() {
      return this.minSpecialCharacters;
   }

   public void setMinSpecialCharacters(Long minSpecialCharacters) {
      this.minSpecialCharacters = minSpecialCharacters;
   }

   public Long getMinLength() {
      return this.minLength;
   }

   public void setMinLength(Long minLength) {
      this.minLength = minLength;
   }

   public Long getMaxLength() {
      return this.maxLength;
   }

   public void setMaxLength(Long maxLength) {
      this.maxLength = maxLength;
   }

   public Long getComposition() {
      return this.composition;
   }

   public void setComposition(Long composition) {
      this.composition = composition;
   }

   public Long getMaxFailedAttempts() {
      return this.maxFailedAttempts;
   }

   public void setMaxFailedAttempts(Long maxFailedAttempts) {
      this.maxFailedAttempts = maxFailedAttempts;
   }

   public Long getExpiryInterval() {
      return this.expiryInterval;
   }

   public void setExpiryInterval(Long expiryInterval) {
      this.expiryInterval = expiryInterval;
   }

   public Long getExpiryWarningInterval() {
      return this.expiryWarningInterval;
   }

   public void setExpiryWarningInterval(Long expiryWarningInterval) {
      this.expiryWarningInterval = expiryWarningInterval;
   }

   public Long getExpiredMaxUse() {
      return this.expiredMaxUse;
   }

   public void setExpiredMaxUse(Long expiredMaxUse) {
      this.expiredMaxUse = expiredMaxUse;
   }

   public Long getReuseInterval() {
      return this.reuseInterval;
   }

   public void setReuseInterval(Long reuseInterval) {
      this.reuseInterval = reuseInterval;
   }

   public Long getHistoryLength() {
      return this.historyLength;
   }

   public void setHistoryLength(Long historyLength) {
      this.historyLength = historyLength;
   }

   public String getLastSuspendedFlag() {
      return this.lastSuspendedFlag;
   }

   public void setLastSuspendedFlag(String lastSuspendedFlag) {
      this.lastSuspendedFlag = lastSuspendedFlag;
   }

   public String getLastSuspendedById() {
      return this.lastSuspendedById;
   }

   public void setLastSuspendedById(String lastSuspendedById) {
      this.lastSuspendedById = lastSuspendedById;
   }

   public String getLastSuspendedByName() {
      return this.lastSuspendedByName;
   }

   public void setLastSuspendedByName(String lastSuspendedByName) {
      this.lastSuspendedByName = lastSuspendedByName;
   }

   public LocalDateTime getLastSuspendedTime() {
      return this.lastSuspendedTime;
   }

   public void setLastSuspendedTime(LocalDateTime lastSuspendedTime) {
      this.lastSuspendedTime = lastSuspendedTime;
   }
}
