/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.metadata.service.impl;

import net.sinodawn.framework.at.AuditTrailHelper;
import net.sinodawn.framework.at.aspect.AuditTrailAspect;
import net.sinodawn.framework.audit.AuditDatabaseOperation;
import net.sinodawn.framework.context.SinoBeanContext;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.database.sql.SqlType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.dao.GenericDao;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.*;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnCommentBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnTargetService;
import net.sinodawn.module.sys.metadata.bean.CoreParentTableInstanceDTO;
import net.sinodawn.module.sys.metadata.bean.CoreTableBean;
import net.sinodawn.module.sys.metadata.bean.CoreTableHierarchyBean;
import net.sinodawn.module.sys.metadata.bean.CoreTablePermissionBean;
import net.sinodawn.module.sys.metadata.dao.CoreTableDao;
import net.sinodawn.module.sys.metadata.dao.CoreTableHierarchyDao;
import net.sinodawn.module.sys.metadata.dao.CoreTablePermissionDao;
import net.sinodawn.module.sys.metadata.mapper.CoreMetadataMapper;
import net.sinodawn.module.sys.metadata.service.CoreTableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class CoreTableServiceImpl implements CoreTableService {
   @Autowired
   private CoreTableDao tableDao;
   @Autowired
   private CoreTableHierarchyDao tableHierarchyDao;
   @Autowired
   private CoreTablePermissionDao tablePermissionDao;
   @Autowired
   private CoreFileService fileService;
   @Autowired
   private CoreMetadataMapper metadataMapper;
   @Autowired
   @Lazy
   private CoreTableService proxyInstance;
   @Autowired
   private CoreBpmnCommentService commentService;
   @Autowired
   private CoreBpmnTargetService bpmnTargetService;

   public CoreTableDao getDao() {
      return this.tableDao;
   }

   public List<CoreParentTableInstanceDTO> selectAncientTableInstanceList(String table, List<? extends Serializable> idList) {
      return this.selectAncientList(table, (List)idList.stream().map((i) -> {
         return Pair.of(i, ConvertUtils.convert(i, String.class));
      }).collect(Collectors.toList()));
   }

   public Map<? extends Serializable, String> selectMasterMap(CoreTableHierarchyBean tableHierarchy, List<? extends Serializable> idList) {
      if (idList.isEmpty()) {
         return CollectionUtils.emptyMap();
      } else {
         List<Map<String, Object>> mapList = this.metadataMapper.selectMasterMap(tableHierarchy.getTableName(), tableHierarchy.getReferColumn(), idList);
         return mapList.stream().collect(Collectors.toMap((m) -> (Serializable)CollectionUtils.getValueIgnorecase(m, "ID"), (m) -> ObjectUtils.toString(CollectionUtils.getValueIgnorecase(m, "MASTERID"))));
      }
   }

   @Transactional
   public <ID extends Serializable> void deleteCascade(String table, ID id) {
      table = table.toUpperCase();
      List childIdList;
      if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(table, AuditDatabaseOperation.DELETE)) {
         AuditTrailAspect.AuditTrailEntryData auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData();
         if (auditTrailEntryData != null) {
            GenericService service = SinoBeanContext.getServiceByTable(table);
            EntityContext entityContext = service.getDao().getEntityContext();
            Object item = service.selectById((Serializable)ConvertUtils.convert(id, entityContext.getIdContext().getType()));
            childIdList = entityContext.getColumnContextList();
            String targetId = AuditTrailAspect.getAncientTargetId(table, id);
            Iterator var9 = childIdList.iterator();

            while(var9.hasNext()) {
               EntityColumnContext columnContext = (EntityColumnContext)var9.next();
               if (AuditTrailHelper.auditTrailableColumn(table, columnContext.getColumnName())) {
                  CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                  line.setRecordType(SqlType.DELETE.name());
                  line.setTargetId(table + "$" + id);
                  line.setTableName(table);
                  line.setColumn(columnContext.getColumnName().toUpperCase());
                  line.setOldValue(ObjectUtils.toString(columnContext.getValue(item)));
                  AuditTrailAspect.addRecordLine(targetId, line);
               }
            }
         }
      }

      List<CoreTableHierarchyBean> tableHierarchyList = this.proxyInstance.selectTableHierarchyByMaster(table);
      if (!tableHierarchyList.isEmpty()) {
         Iterator var13 = tableHierarchyList.iterator();

         while(var13.hasNext()) {
            CoreTableHierarchyBean tableHierarchy = (CoreTableHierarchyBean)var13.next();
            CoreTableBean coreTable = this.proxyInstance.selectTable(tableHierarchy.getTableName());
            childIdList = this.metadataMapper.selectIdByMaster(coreTable.getId(), tableHierarchy.getReferColumn(), id);
            Iterator var21 = childIdList.iterator();

            while(var21.hasNext()) {
               String childId = (String)var21.next();
               this.deleteCascade(coreTable.getId(), childId);
            }
         }
      }

      CoreTableBean coreTable = this.proxyInstance.selectTable(table);
      if (coreTable != null) {
         if ("1".equals(coreTable.getAuditable())) {
            CoreBpmnCommentBean filter = new CoreBpmnCommentBean();
            filter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
            this.commentService.getDao().deleteBy((List<CoreBpmnCommentBean>) filter, "TARGETID");
            this.bpmnTargetService.delete(filter.getTargetId());
         }

         if ("1".equals(coreTable.getAttachment())) {
            this.fileService.delete(coreTable.getId(), id);
         }
      }

      GenericDao<?, ?> dao = SinoBeanContext.getServiceByTable(table).getDao();
      if (dao != null) {
         Object convertId = ConvertUtils.convert(id, dao.getEntityContext().getIdContext().getType());
         Class<?> daoClazz = ClassUtils.getRawType(dao.getClass());
         Method deleteMethod = ReflectionUtils.findMethodByName(daoClazz, "delete");
         ReflectionUtils.invokeMethod(deleteMethod, dao, convertId);
      }

   }

//   @SinoCacheable({"T_CORE_TABLE_HIERARCHY.MASTERTABLE"})
   public List<CoreTableHierarchyBean> selectTableHierarchyByMaster(String masterTable) {
      CoreTableHierarchyBean terms = new CoreTableHierarchyBean();
      terms.setMasterTableName(masterTable);
      return this.tableHierarchyDao.selectList(terms, new Order[]{Order.desc("ID")});
   }

//   @SinoCacheable({"T_CORE_TABLE_HIERARCHY.TABLENAME"})
   public List<CoreTableHierarchyBean> selectTableHierarchy(String table) {
      CoreTableHierarchyBean filter = new CoreTableHierarchyBean();
      filter.setTableName(table);
      return this.tableHierarchyDao.selectList(filter, new Order[0]);
   }

   public <ID> CoreTableHierarchyBean selectTableHierarchy(String table, ID id) {
      List<CoreTableHierarchyBean> tableHierarchyList = this.proxyInstance.selectTableHierarchy(table);
      if (tableHierarchyList.isEmpty()) {
         return null;
      } else if (tableHierarchyList.size() == 1) {
         return (CoreTableHierarchyBean)tableHierarchyList.get(0);
      } else {
         Iterator var4 = tableHierarchyList.iterator();

         CoreTableHierarchyBean tableHierarchy;
         do {
            if (!var4.hasNext()) {
               return null;
            }

            tableHierarchy = (CoreTableHierarchyBean)var4.next();
         } while(this.metadataMapper.countMaster(tableHierarchy.getTableName(), tableHierarchy.getMasterTableName(), tableHierarchy.getReferColumn(), id) <= 0L);

         return tableHierarchy;
      }
   }

//   @SinoCacheable(
//      value = {"core-table-permission"},
//      keyGenerator = "sinoConcatParamsKeyGenerator"
//   )
   public CoreTablePermissionBean selectTablePermission(String table, String category) {
      CoreTablePermissionBean tablePermission = new CoreTablePermissionBean();
      tablePermission.setTableName(table);
      tablePermission.setCategory(category);
      return (CoreTablePermissionBean)this.tablePermissionDao.selectOneIfPresent(tablePermission, new String[0]);
   }

   public CoreTableBean selectTable(String table) {
      return (CoreTableBean)this.getDao().selectByIdIfPresent(table);
   }

   public Page<ColumnContext> selectTableColumnList(String table, RestJsonWrapperBean wrapper) {
      return new Pagination(DatabaseManager.getTableColumnContextList(table));
   }

   private List<CoreParentTableInstanceDTO> selectAncientList(String table, List<Pair<?, String>> pairList) {
      CoreTableHierarchyBean tableHierarchy = this.proxyInstance.selectTableHierarchy(table, ((Pair)pairList.get(0)).getSecond());
      if (tableHierarchy == null) {
         List<CoreParentTableInstanceDTO> instanceList = new ArrayList();
         pairList.forEach((p) -> {
            CoreParentTableInstanceDTO instance = new CoreParentTableInstanceDTO();
            instance.setSourceId((String)ConvertUtils.convert(p.getFirst(), String.class));
            instance.setTable(table);
            instance.setId((String)p.getSecond());
            instanceList.add(instance);
         });
         return instanceList;
      } else {
         Map<? extends Serializable, String> masterMap = this.selectMasterMap(tableHierarchy, (List)pairList.stream().map((p) -> {
            return (String)p.getSecond();
         }).distinct().collect(Collectors.toList()));
         masterMap.forEach((k, v) -> {
            ((Pair)pairList.stream().filter((p) -> {
               return ((String)p.getSecond()).equals(ConvertUtils.convert(k, String.class));
            }).findAny().get()).setSecond(v);
         });
         return this.selectAncientList(tableHierarchy.getMasterTableName(), pairList);
      }
   }
}
