/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.metadata.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.metadata.bean.CoreParentTableInstanceDTO;
import net.sinodawn.module.sys.metadata.bean.CoreTableBean;
import net.sinodawn.module.sys.metadata.bean.CoreTableHierarchyBean;
import net.sinodawn.module.sys.metadata.bean.CoreTablePermissionBean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public interface CoreTableService extends GenericService<CoreTableBean, String> {
   List<CoreParentTableInstanceDTO> selectAncientTableInstanceList(String table, List<? extends Serializable> idList);

   <ID extends Serializable> void deleteCascade(String table, ID id);

   default String selectMasterId(CoreTableHierarchyBean tableHierarchy, Serializable id) {
      Map<? extends Serializable, String> map = this.selectMasterMap(tableHierarchy, Arrays.asList(id));
      return map.isEmpty() ? null : (String)map.values().iterator().next();
   }

   Map<? extends Serializable, String> selectMasterMap(CoreTableHierarchyBean tableHierarchy, List<? extends Serializable> idList);

   List<CoreTableHierarchyBean> selectTableHierarchyByMaster(String masterTable);

   CoreTableBean selectTable(String table);

   List<CoreTableHierarchyBean> selectTableHierarchy(String table);

   <ID> CoreTableHierarchyBean selectTableHierarchy(String table, ID id);

   CoreTablePermissionBean selectTablePermission(String table, String category);

   Page<ColumnContext> selectTableColumnList(String table, RestJsonWrapperBean wrapper);
}
