/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.metadata.mapper;

import net.sinodawn.module.sys.metadata.bean.CoreValidatorBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Mapper
public interface CoreMetadataMapper {
   List<CoreValidatorBean> selectEnabledValidatorByTable(String table);

   List<Map<String, Object>> selectMasterMap(@Param("table") String table, @Param("referColumn") String referColumn, @Param("idList") List<? extends Serializable> idList);

   <ID> List<String> selectIdByMaster(@Param("table") String table, @Param("referColumn") String referColumn, @Param("masterId") ID masterId);

   <ID> void deleteByMaster(@Param("table") String table, @Param("referColumn") String referColumn, @Param("masterId") ID masterId);

   <ID> void delete(@Param("table") String table, @Param("id") ID id);

   <ID> long countMaster(@Param("table") String table, @Param("masterTable") String masterTable, @Param("referColumn") String referColumn, @Param("id") ID id);

   List<Map<String, Object>> selectImpValidatorByTable(@Param("table") String table);

   List<Map<String, Object>> selectSubmitValidatorByTable(@Param("table") String table);
}
