/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.metadata.bean;

import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.Table;
import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Persistable;

@Table("T_CORE_TABLE_HIERARCHY")
public class CoreTableHierarchyBean extends AbstractPersistable<Long> implements Persistable<Long> {
   @Transient
   private static final long serialVersionUID = -6157635559493863765L;
   @Id
   private Long id;
   private String tableName;
   private String masterTableName;
   private String referColumn;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getTableName() {
      return this.tableName;
   }

   public void setTableName(String tableName) {
      this.tableName = tableName;
   }

   public String getMasterTableName() {
      return this.masterTableName;
   }

   public void setMasterTableName(String masterTableName) {
      this.masterTableName = masterTableName;
   }

   public String getReferColumn() {
      return this.referColumn;
   }

   public void setReferColumn(String referColumn) {
      this.referColumn = referColumn;
   }
}
