/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.metadata.bean;

import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Persistable;

@Table("T_CORE_METADATA")
public class CoreMetadataBean extends AbstractPersistable<Long> implements Persistable<Long> {
   @Transient
   private static final long serialVersionUID = -1311987661516227493L;
   @Id
   private Long id;
   private String tableName;
   private String columnName;
   private String typeName;
   private String note;
   @NotNull(
      defaultValue = "0"
   )
   private String modifiable;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
   }

   public String getTableName() {
      return this.tableName;
   }

   public void setTableName(String tableName) {
      this.tableName = tableName;
   }

   public String getColumnName() {
      return this.columnName;
   }

   public void setColumnName(String columnName) {
      this.columnName = columnName;
   }

   public String getTypeName() {
      return this.typeName;
   }

   public void setTypeName(String typeName) {
      this.typeName = typeName;
   }

   public String getNote() {
      return this.note;
   }

   public void setNote(String note) {
      this.note = note;
   }
}
