/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.log.service.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.module.sys.log.bean.CoreLogBean;
import net.sinodawn.module.sys.log.dao.CoreLogDao;
import net.sinodawn.module.sys.log.service.CoreLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
@Repository
public class CoreLogServiceImpl implements CoreLogService {
   @Autowired
   private CoreLogDao logDao;

   public CoreLogDao getDao() {
      return this.logDao;
   }

   @Transactional
   public void insertLog(List<CoreLogBean> insertSysLogList) {
      List<Long> keyList = ApplicationContextHelper.getNextIdentityList(insertSysLogList.size());
      int i = 0;

      for(int j = insertSysLogList.size(); i < j; ++i) {
         ((CoreLogBean)insertSysLogList.get(i)).setId((Long)keyList.get(i));
      }

      this.getDao().insert(insertSysLogList);
   }
}
