/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.log.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.log.bean.CoreLoginLogBean;
import org.springframework.lang.Nullable;

import java.util.List;

public interface CoreLoginLogService extends GenericService<CoreLoginLogBean, Long> {
   void insertLoginSuccessLog(String token, String userId, String orgId);

   void insertLoginFailureLog(String userId, String remark);

   void assignLogout(String token, String remark);

   List<CoreLoginLogBean> selectOnlineUserLoginLogList(@Nullable String userId);

   CoreLoginLogBean getCurrentLoginLog(String userId);

   Page<CoreLoginLogBean> selectOnlinePagination(RestJsonWrapperBean wrapper);

   void offline(RestJsonWrapperBean wrapper);
}
