/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.log.bean;

import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.Clob;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_LOG")
public class CoreLogBean extends AbstractPersistable<Long> implements Persistable<Long> {
   @Transient
   private static final long serialVersionUID = -3158953016249216302L;
   @Id
   private Long id;
   private String module;
   private String name;
   private String sessionId;
   private String userId;
   private String userName;
   private String loginIp;
   @JSONField(
      format = "yyyy-MM-dd HH:mm:ss"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime startTime;
   @JSONField(
      format = "yyyy-MM-dd HH:mm:ss"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime endTime;
   // TODO定义常量
   @NotNull(defaultValue = "test")
   private String type;
   private String requestUri;
   private String signature;
   @Clob
   private String content;
   private LocalDateTime createdTime;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getModule() {
      return this.module;
   }

   public void setModule(String module) {
      this.module = module;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getSessionId() {
      return this.sessionId;
   }

   public void setSessionId(String sessionId) {
      this.sessionId = sessionId;
   }

   public String getUserId() {
      return this.userId;
   }

   public void setUserId(String userId) {
      this.userId = userId;
   }

   public String getUserName() {
      return this.userName;
   }

   public void setUserName(String userName) {
      this.userName = userName;
   }

   public String getLoginIp() {
      return this.loginIp;
   }

   public void setLoginIp(String loginIp) {
      this.loginIp = loginIp;
   }

   public LocalDateTime getStartTime() {
      return this.startTime;
   }

   public void setStartTime(LocalDateTime startTime) {
      this.startTime = startTime;
   }

   public LocalDateTime getEndTime() {
      return this.endTime;
   }

   public void setEndTime(LocalDateTime endTime) {
      this.endTime = endTime;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public String getRequestUri() {
      return this.requestUri;
   }

   public void setRequestUri(String requestUri) {
      this.requestUri = requestUri;
   }

   public String getSignature() {
      return this.signature;
   }

   public void setSignature(String signature) {
      this.signature = signature;
   }

   public String getContent() {
      return this.content;
   }

   public void setContent(String content) {
      this.content = content;
   }

   public LocalDateTime getCreatedTime() {
      return this.createdTime;
   }

   public void setCreatedTime(LocalDateTime createdTime) {
      this.createdTime = createdTime;
   }

   public String toLogString() {
      StringBuilder msg = (new StringBuilder(this.getName())).append("[").append(this.getType()).append("]\n").append(this.getSignature());
      if (!StringUtils.isEmpty(this.getContent())) {
         msg.append("\n").append(StringUtils.abbreviate(this.getContent()));
      }

      return msg.toString();
   }
}
