/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.log.bean;

import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_EXPORT_LOG")
public class CoreExportLogBean extends AbstractPersistable<Long> implements Insertable<Long> {
   @Transient
   private static final long serialVersionUID = -6630823232675986297L;
   @Id
   private Long id;
   private String fileName;
   private String exportMode;
   private String url;
   private String createdById;
   private String createdByName;
   @JSONField(
      format = "yyyy-MM-dd HH:mm:ss"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime createdTime;
   private String createdByOrgId;
   private String createdByOrgName;

   public Long getId() {
      return this.id;
   }

   public String getFileName() {
      return this.fileName;
   }

   public String getExportMode() {
      return this.exportMode;
   }

   public String getUrl() {
      return this.url;
   }

   public String getCreatedById() {
      return this.createdById;
   }

   public String getCreatedByName() {
      return this.createdByName;
   }

   public LocalDateTime getCreatedTime() {
      return this.createdTime;
   }

   public String getCreatedByOrgId() {
      return this.createdByOrgId;
   }

   public String getCreatedByOrgName() {
      return this.createdByOrgName;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public void setFileName(String fileName) {
      this.fileName = fileName;
   }

   public void setExportMode(String exportMode) {
      this.exportMode = exportMode;
   }

   public void setUrl(String url) {
      this.url = url;
   }

   public void setCreatedById(String createdById) {
      this.createdById = createdById;
   }

   public void setCreatedByName(String createdByName) {
      this.createdByName = createdByName;
   }

   public void setCreatedTime(LocalDateTime createdTime) {
      this.createdTime = createdTime;
   }

   public void setCreatedByOrgId(String createdByOrgId) {
      this.createdByOrgId = createdByOrgId;
   }

   public void setCreatedByOrgName(String createdByOrgName) {
      this.createdByOrgName = createdByOrgName;
   }
}
