/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.constant.dao.impl;

import net.sinodawn.framework.mybatis.dao.MybatisDaoSupport;
import net.sinodawn.module.sys.constant.bean.CoreConstantBean;
import net.sinodawn.module.sys.constant.dao.CoreConstantDao;
import net.sinodawn.module.sys.constant.mapper.CoreConstantMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class CoreConstantDaoImpl extends MybatisDaoSupport<CoreConstantBean, String> implements CoreConstantDao {
   @Autowired
   private CoreConstantMapper constantMapper;

   public CoreConstantMapper getMapper() {
      return this.constantMapper;
   }

   public List<CoreConstantBean> selectAll() {
      return CoreConstantDao.super.selectAll();
   }

   @Cacheable(
      value = {"T_CORE_CONSTANT"},
      key = "#id",
      unless = "#result == null"
   )
   public CoreConstantBean selectByIdIfPresent(String id) {
      return (CoreConstantBean)super.selectByIdIfPresent(id);
   }

   @CacheEvict(
      value = {"T_CORE_CONSTANT"},
      keyGenerator = "defaultDaoCacheEvictKeyGenerator"
   )
   public void cacheEvict(CoreConstantBean oldItem, CoreConstantBean newItem) {
   }
}
