/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.config.service.impl;

import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.manager.CoreFileManager;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.sys.config.bean.CoreSystemConfigBean;
import net.sinodawn.module.sys.config.bean.CoreSystemConfigDTO;
import net.sinodawn.module.sys.config.bean.CoreSystemConfigHelpManualDTO;
import net.sinodawn.module.sys.config.dao.CoreSystemConfigDao;
import net.sinodawn.module.sys.config.service.CoreSystemConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class CoreSystemConfigServiceImpl implements CoreSystemConfigService {
   private static final String SYSTEM_CONFIG_ID = "system-config";
   private static final String FILE_TARGETID = "T_CORE_SYSTEM_CONFIG$system-config";
   @Autowired
   private CoreSystemConfigDao coreSystemConfigDao;
   @Autowired
   private CoreFileService coreFileService;
   @Lazy
   @Autowired
   private CoreSystemConfigService proxyInstance;
   @Autowired
   @Lazy
   private CoreFileManager fileManager;

   public CoreSystemConfigDao getDao() {
      return this.coreSystemConfigDao;
   }

   @Cacheable(
      value = {"CORE-SYSTEM-CONFIG"},
      key = "'system'"
   )
   public CoreSystemConfigDTO selectSystemConfig() {
      CoreSystemConfigBean systemConfig = (CoreSystemConfigBean)this.getDao().selectById("system-config");
      CoreSystemConfigDTO systemConfigDTO = new CoreSystemConfigDTO();
      BeanUtils.copyProperties((Object)systemConfig, systemConfigDTO);
      CoreFileBean helpManualFile = (CoreFileBean)this.coreFileService.selectFirstByFilter(SearchFilter.instance().match((String)"TARGETID", "T_CORE_SYSTEM_CONFIG$system-config").filter(MatchPattern.EQ).match((String)"BIZCATEGORY", "HELPMANNUAL").filter(MatchPattern.EQ), new Order[]{Order.desc("ID")});
      if (helpManualFile != null) {
         CoreSystemConfigHelpManualDTO helpManual = new CoreSystemConfigHelpManualDTO();
         helpManual.setFileId(helpManualFile.getId());
         helpManual.setFileName(helpManualFile.getName());
         helpManual.setDownloadUrl(this.fileManager.getDownloadUrl(helpManualFile));
         systemConfigDTO.setHelpManual(helpManual);
      }

      return systemConfigDTO;
   }

   public CoreSystemConfigBean selectDetail(String id) {
      return this.proxyInstance.selectSystemConfig();
   }

   @CacheEvict(
      value = {"CORE-SYSTEM-CONFIG"},
      key = "'system'"
   )
   public void save(String id, RestJsonWrapperBean wrapper) {
      CoreSystemConfigService.super.save(id, wrapper);
   }
}
