/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.config.service.impl;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.config.bean.CoreLoginConfigBean;
import net.sinodawn.module.sys.config.dao.CoreLoginConfigDao;
import net.sinodawn.module.sys.config.service.CoreLoginConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class CoreLoginConfigServiceImpl implements CoreLoginConfigService {
   private static final String Login_CONFIG_ID = "login-config";
   @Autowired
   private CoreLoginConfigDao coreLoginConfigDao;
   @Lazy
   @Autowired
   private CoreLoginConfigService proxyInstance;

   public CoreLoginConfigDao getDao() {
      return this.coreLoginConfigDao;
   }

   @Cacheable(
      value = {"CORE-LOGIN-CONFIG"},
      key = "'login'"
   )
   public CoreLoginConfigBean selectLoginConfig() {
      return (CoreLoginConfigBean)this.getDao().selectById("login-config");
   }

   public CoreLoginConfigBean selectDetail(String id) {
      return this.proxyInstance.selectLoginConfig();
   }

   @CacheEvict(
      value = {"CORE-LOGIN-CONFIG"},
      key = "'login'"
   )
   public void save(String id, RestJsonWrapperBean wrapper) {
      CoreLoginConfigService.super.save(id, wrapper);
   }
}
