/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.validator;

import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.data.DataValidator;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreBpmnProcDeletableValidator implements DataValidator {
   @Autowired
   private CoreBpmnProcService procService;
   @Autowired
   private CoreBpmnInstanceService instanceService;

   public boolean doValid(Object... args) {
      List<CoreBpmnProcBean> deleteProcList = ((RestJsonWrapperBean)args[0]).parse(CoreBpmnProcBean.class);
      List<Long> procIdList = (List)deleteProcList.stream().map(CoreBpmnProcBean::getId).collect(Collectors.toList());
      List<CoreBpmnInstanceBean> instanceList = this.instanceService.getDao().selectListByOneColumnValues(procIdList, "PROCID");
      if (!instanceList.isEmpty()) {
         List<Long> usedProcIdList = (List)instanceList.stream().map(CoreBpmnInstanceBean::getProcId).collect(Collectors.toList());
         List<CoreBpmnProcBean> usedProcList = this.procService.selectListByIds(usedProcIdList);
         StringBuilder sb = new StringBuilder();

         CoreBpmnProcBean usedProc;
         for(Iterator var8 = usedProcList.iterator(); var8.hasNext(); sb.append(usedProc.getProcCode())) {
            usedProc = (CoreBpmnProcBean)var8.next();
            if (sb.length() > 0) {
               sb.append(",");
            }
         }

         this.addConstraintViolation(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_PROC.TIP.UNABLE_DELETE_INUSE_PROC", sb.toString()));
         return false;
      } else {
         return true;
      }
   }
}
