/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.validator;

import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.framework.validator.data.DataValidator;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftOrgBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreBpmnDraftSubmittableValidator implements DataValidator {
   @Autowired
   private CoreBpmnProcService procService;
   @Autowired
   private CoreBpmnProcOrgService procOrgService;
   @Autowired
   private CoreBpmnDraftService draftService;
   @Autowired
   private CoreBpmnDraftOrgService draftOrgService;
   @Autowired
   private CoreBpmnDiagramService diagramService;

   public boolean doValid(Object... args) {
      Long id = (Long)args[0];
      CoreBpmnDraftBean draft = this.draftService.selectById(id);
      Long diagramId = draft.getDiagramId();
      String diagram = (String)this.diagramService.selectColumnById(diagramId, "DIAGRAM", String.class);
      if (StringUtils.isBlank(diagram)) {
         this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.CANNOT_EMPTY");
         return false;
      } else {
         Document document = XmlUtils.read(CoreBpmnHelper.getCorrectedDiagram(diagram));
         boolean flag = true;
         List<Element> startEventList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.START_EVENT);
         if (startEventList.isEmpty()) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.NO_START_EVENT");
            flag = false;
         } else if (startEventList.size() > 1) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MULTIPLE_START_EVENT");
            flag = false;
         }

         List<Element> endEventList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.END_EVENT);
         if (endEventList.isEmpty()) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.NO_END_EVENT");
            flag = false;
         } else if (endEventList.size() > 1) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MULTIPLE_END_EVENT");
            flag = false;
         }

         List userTaskList;
         if (flag) {
            userTaskList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.USER_TASK);
            if (!userTaskList.isEmpty()) {
               Iterator var11 = userTaskList.iterator();

               while(var11.hasNext()) {
                  Element userTask = (Element)var11.next();
                  String statusCode = XmlUtils.getAttributeValue(userTask, "statusCode");
                  if (StringUtils.isEmpty(statusCode)) {
                     this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.STATUS_CODE_NOT_ASSIGNED");
                     return false;
                  }

                  Element startEvent = startEventList.get(0);
                  Element endEvent = endEventList.get(0);
                  if (statusCode.equals(XmlUtils.getAttributeValue(startEvent, "statusCode")) || statusCode.equals(XmlUtils.getAttributeValue(endEvent, "statusCode")) || userTaskList.stream().filter((u) -> {
                     return statusCode.equals(XmlUtils.getAttributeValue((Element) u, "statusCode"));
                  }).count() > 1L) {
                     this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.STATUS_CODE_NOT_UNIQUE");
                     return false;
                  }

                  String dynamic = XmlUtils.getAttributeValue(userTask, "dynamic");
                  if (!StringUtils.isEmpty(dynamic)) {
                     String[] dynamicValues = StringUtils.split(dynamic, ",");
                     String[] var16 = dynamicValues;
                     int var17 = dynamicValues.length;

                     for(int var18 = 0; var18 < var17; ++var18) {
                        String value = var16[var18];
                        if (!StringUtils.startsWith(value, "u:") && !StringUtils.startsWith(value, "r:")) {
                           this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.DYNAMIC_INVALID");
                           return false;
                        }
                     }
                  }
               }
            }
         }

         if (flag) {
            CoreBpmnProcBean filter = new CoreBpmnProcBean();
            filter.setProcCode(draft.getProcCode());
            CoreBpmnProcBean proc = (CoreBpmnProcBean)this.procService.getDao().selectFirstIfPresent(filter, Order.desc("ID"));
            if (proc != null && proc.getProcVersion() + 1L != draft.getProcVersion()) {
               this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.INVALID_VERSION");
               return false;
            }
         }

         if (flag) {
            userTaskList = this.procService.selectBpmnProcListByServiceId(draft.getServiceId());
            if (!userTaskList.isEmpty()) {
               CoreBpmnDraftOrgBean draftOrgFilter = new CoreBpmnDraftOrgBean();
               draftOrgFilter.setDraftId(draft.getId());
               List<CoreBpmnDraftOrgBean> draftOrgList = this.draftOrgService.selectList(draftOrgFilter);
               Iterator var24 = userTaskList.iterator();

               while(var24.hasNext()) {
                  CoreBpmnProcBean proc = (CoreBpmnProcBean)var24.next();
                  if (!proc.getProcCode().equals(draft.getProcCode()) && ObjectUtils.equals(StringUtils.trim(proc.getExpression()), StringUtils.trim(draft.getExpression()))) {
                     CoreBpmnProcOrgBean procOrgFilter = new CoreBpmnProcOrgBean();
                     procOrgFilter.setProcId(proc.getId());
                     List<CoreBpmnProcOrgBean> procOrgList = this.procOrgService.selectList(procOrgFilter, new Order[0]);
                     if (procOrgList.isEmpty()) {
                        if (draftOrgList.isEmpty()) {
//                           this.addConstraintViolation(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.DEFAULT_NOT_UNIQU", proc.getProcCode()));
                           return false;
                        }
                     } else if (!draftOrgList.isEmpty() && procOrgList.stream().anyMatch((o) -> {
                        return draftOrgList.stream().anyMatch((d) -> {
                           return d.getUsedOrgId().equals(o.getUsedOrgId());
                        });
                     })) {
//                        this.addConstraintViolation(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.EXPRESSION_AND_ORG_NOT_UNIQUE", proc.getProcCode()));
                        return false;
                     }
                  }
               }
            }
         }

         return flag;
      }
   }
}
