/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTargetBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnTargetDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnTargetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CoreBpmnTargetServiceImpl implements CoreBpmnTargetService {
   @Autowired
   private CoreBpmnTargetDao targetDao;

   public CoreBpmnTargetDao getDao() {
      return this.targetDao;
   }

   public Page<CoreBpmnTargetBean> selectPagination(MapperParameter parameter, PageRowBounds rowBounds) {
      Page<CoreBpmnTargetBean> targetList = CoreBpmnTargetService.super.selectPagination(parameter, rowBounds);
      targetList.getRows().forEach((r) -> {
         String href = r.getExt$Item("href");
         if (!StringUtils.isEmpty(href)) {
            r.setExt$Item("href", href.substring(0, href.indexOf("/page/")));
         }

      });
      return targetList;
   }
}
