/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnInstanceTaskDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskRoleService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public class CoreBpmnInstanceTaskServiceImpl implements CoreBpmnInstanceTaskService {
   @Autowired
   private CoreBpmnInstanceTaskDao instanceTaskDao;
   @Autowired
   private CoreBpmnInstanceTaskUserService instanceTaskUserService;
   @Autowired
   private CoreBpmnInstanceTaskRoleService instanceTaskRoleService;

   public CoreBpmnInstanceTaskDao getDao() {
      return this.instanceTaskDao;
   }

   public List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(@Nullable String userId, List<Long> instIdList) {
      return this.getDao().selectAuditableInstanceTaskList(userId, instIdList);
   }

   @Async
   @Transactional
   public void cleanCandidatorAsync(Long id) {
      CoreBpmnInstanceTaskUserBean taskUserFilter = new CoreBpmnInstanceTaskUserBean();
      taskUserFilter.setInstTaskId(id);
      this.instanceTaskUserService.getDao().deleteBy(taskUserFilter, "INSTTASKID");
      CoreBpmnInstanceTaskRoleBean taskRoleFilter = new CoreBpmnInstanceTaskRoleBean();
      taskRoleFilter.setInstTaskId(id);
      this.instanceTaskRoleService.getDao().deleteBy(taskRoleFilter, "INSTTASKID");
   }

   public Page<CoreBpmnInstanceTaskUserBean> selectInstTaskUserList(Long id, RestJsonWrapperBean wrapper) {
      return this.instanceTaskUserService.selectPaginationByFilter(SearchFilter.instance().match((String)"INSTTASKID", id).filter(MatchPattern.EQ), wrapper);
   }

   public Page<CoreBpmnInstanceTaskRoleBean> selectInstTaskRoleList(Long id, RestJsonWrapperBean wrapper) {
      return this.instanceTaskRoleService.selectPaginationByFilter(SearchFilter.instance().match((String)"INSTTASKID", id).filter(MatchPattern.EQ), wrapper);
   }

   @Transactional
   public void insertInstTaskUser(Long id, RestJsonWrapperBean wrapper) {
      List<CoreBpmnInstanceTaskUserBean> instanceTaskUserList = wrapper.parse(CoreBpmnInstanceTaskUserBean.class);
      CoreBpmnInstanceTaskBean instanceTask = (CoreBpmnInstanceTaskBean)this.getDao().selectById(id);
      instanceTaskUserList.forEach((t) -> {
         t.setId(ApplicationContextHelper.getNextIdentity());
         t.setInstId(instanceTask.getInstId());
         t.setInstTaskId(id);
      });
      this.instanceTaskUserService.getDao().insert(instanceTaskUserList);
   }

   @Transactional
   public void insertInstTaskRole(Long id, RestJsonWrapperBean wrapper) {
      List<CoreBpmnInstanceTaskRoleBean> instanceTaskRoleList = wrapper.parse(CoreBpmnInstanceTaskRoleBean.class);
      CoreBpmnInstanceTaskBean instanceTask = (CoreBpmnInstanceTaskBean)this.getDao().selectById(id);
      instanceTaskRoleList.forEach((t) -> {
         t.setId(ApplicationContextHelper.getNextIdentity());
         t.setInstId(instanceTask.getInstId());
         t.setInstTaskId(id);
      });
      this.instanceTaskRoleService.getDao().insert(instanceTaskRoleList);
   }

   @Transactional
   public void deleteInstTaskUser(Long id, RestJsonWrapperBean wrapper) {
      List<CoreBpmnInstanceTaskUserBean> instanceTaskUserList = wrapper.parse(CoreBpmnInstanceTaskUserBean.class);
      this.instanceTaskUserService.getDao().deleteBy(instanceTaskUserList);
   }

   @Transactional
   public void deleteInstTaskRole(Long id, RestJsonWrapperBean wrapper) {
      List<CoreBpmnInstanceTaskRoleBean> instanceTaskRoleList = wrapper.parse(CoreBpmnInstanceTaskRoleBean.class);
      this.instanceTaskRoleService.getDao().deleteBy(instanceTaskRoleList);
   }
}
