/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service.impl;

import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskCandidatorDTO;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnInstanceDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class CoreBpmnInstanceServiceImpl implements CoreBpmnInstanceService {
   @Autowired
   private CoreBpmnInstanceDao instanceDao;

   public CoreBpmnInstanceDao getDao() {
      return this.instanceDao;
   }

   public List<CoreBpmnInstanceCandidatorDTO> selectInstanceCandidatorList(List<Long> idList) {
      return this.getDao().selectInstanceCandidatorList(idList);
   }

   public List<CoreBpmnInstanceTaskCandidatorDTO> selectInstanceTaskAuditorList(List<Long> idList) {
      return this.getDao().selectInstanceTaskAuditorList(idList);
   }
}
