/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnCommentDTO;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnCommentDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class CoreBpmnCommentServiceImpl implements CoreBpmnCommentService {
   @Autowired
   private CoreBpmnCommentDao commentDao;

   public CoreBpmnCommentDao getDao() {
      return this.commentDao;
   }

   public Page<CoreBpmnCommentDTO> selectCommentList(String table, String id) {
      return new Pagination(this.getDao().selectCommentList(table + "$" + ObjectUtils.toString(id)));
   }

   public List<String> selectUserTaskAuditedByList(String targetId, String statusCode) {
      return this.getDao().selectUserTaskAuditedByList(targetId, statusCode);
   }
}
