/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import java.util.List;

public interface CoreBpmnProcService extends GenericService<CoreBpmnProcBean, Long> {
   List<CoreBpmnProcBean> selectRuntimeBpmnProcList(String tableName, String usedOrgId);

   List<CoreBpmnProcBean> selectBpmnProcListByServiceId(String serviceId);

   CoreBpmnProcBean selectLatestProc(String procCode);

   void cacheEvictLatestProc(String procCode);

   String getBpmnInputTextUrl(Long id);

   Page<CoreBpmnProcOrgBean> selectProcOrgPagination(Long id, RestJsonWrapperBean wrapper);
}
