/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import java.util.List;
import org.springframework.lang.Nullable;

public interface CoreBpmnInstanceTaskService extends GenericService<CoreBpmnInstanceTaskBean, Long> {
   List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(@Nullable String userId, List<Long> instIdList);

   void cleanCandidatorAsync(Long id);

   Page<CoreBpmnInstanceTaskUserBean> selectInstTaskUserList(Long id, RestJsonWrapperBean wrapper);

   Page<CoreBpmnInstanceTaskRoleBean> selectInstTaskRoleList(Long id, RestJsonWrapperBean wrapper);

   void insertInstTaskUser(Long id, RestJsonWrapperBean wrapper);

   void deleteInstTaskUser(Long id, RestJsonWrapperBean wrapper);

   void insertInstTaskRole(Long id, RestJsonWrapperBean wrapper);

   void deleteInstTaskRole(Long id, RestJsonWrapperBean wrapper);
}
