/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftOrgBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnImportDTO;
import java.util.List;

public interface CoreBpmnDraftService extends GenericService<CoreBpmnDraftBean, Long> {
   Long insert(RestJsonWrapperBean wrapper);

   Long insertByProcId(Long procId);

   void submit(Long id);

   void importBpmn(List<CoreBpmnImportDTO> bpmnImportList);

   Page<CoreBpmnDraftOrgBean> selectDraftOrgPagination(Long id, RestJsonWrapperBean wrapper);

   void insertDraftOrg(Long id, RestJsonWrapperBean wrapper);

   void deleteDraftOrg(Long id, RestJsonWrapperBean wrapper);
}
