/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.data.annotation.ValidateDataWith;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import net.sinodawn.module.sys.bpmn.resource.CoreBpmnProcResource;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import net.sinodawn.module.sys.bpmn.validator.CoreBpmnProcDeletableValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@LogModule("工作流程")
public class CoreBpmnProcResourceImpl implements CoreBpmnProcResource {
   @Autowired
   private CoreBpmnProcService procService;

   public CoreBpmnProcService getService() {
      return this.procService;
   }

   public String getBpmnInputTextUrl(@PathVariable Long id) {
      return this.getService().getBpmnInputTextUrl(id);
   }

   @Log(
      value = "通过流程定义编码查询使用部门",
      type = LogType.SELECT
   )
   public Page<CoreBpmnProcOrgBean> selectProcOrgPagination(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      return this.getService().selectProcOrgPagination(id, wrapper);
   }

   @Log(
      value = "删除",
      type = LogType.DELETE
   )
   @RequestMapping(
      method = {RequestMethod.DELETE}
   )
   @ValidateDataWith(CoreBpmnProcDeletableValidator.class)
   public void delete(RestJsonWrapperBean wrapper) {
      CoreBpmnProcResource.super.delete(wrapper);
   }
}
