/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.resource.CoreBpmnInstanceTaskResource;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@LogModule("流程执行实例")
public class CoreBpmnInstanceTaskResourceImpl implements CoreBpmnInstanceTaskResource {
   @Autowired
   private CoreBpmnInstanceTaskService instanceTaskService;

   public CoreBpmnInstanceTaskService getService() {
      return this.instanceTaskService;
   }

   public Page<CoreBpmnInstanceTaskUserBean> selectInstTaskUserList(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      return this.getService().selectInstTaskUserList(id, wrapper);
   }

   public Page<CoreBpmnInstanceTaskRoleBean> selectInstTaskRoleList(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      return this.getService().selectInstTaskRoleList(id, wrapper);
   }

   public void insertInstTaskUser(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().insertInstTaskUser(id, wrapper);
   }

   public void insertInstTaskRole(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().insertInstTaskRole(id, wrapper);
   }

   public void deleteInstTaskUser(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().deleteInstTaskUser(id, wrapper);
   }

   public void deleteInstTaskRole(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().deleteInstTaskRole(id, wrapper);
   }
}
