/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnRejectableTaskDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnRuntimeDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTargetBean;
import net.sinodawn.module.sys.bpmn.resource.CoreBpmnExtResource;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnExtService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@LogModule("工作流程信息")
public class CoreBpmnExtResourceImpl implements CoreBpmnExtResource {
   @Autowired
   private CoreBpmnExtService extService;

   @Log(
      value = "获取工作流运行中的信息",
      type = LogType.SELECT
   )
   public CoreBpmnRuntimeDTO selectBpmnRuntimeInfo(@RequestParam String table, @RequestParam String id) {
      return this.extService.selectBpmnRuntimeInfo(table, id);
   }

   @Log(
      value = "获取工作流运行中可回退节点的信息",
      type = LogType.SELECT
   )
   public List<CoreBpmnRejectableTaskDTO> selectBpmnRuntimeRejectableTaskList(RestJsonWrapperBean wrapper) {
      return this.extService.selectBpmnRuntimeRejectableTaskList(wrapper);
   }

   @Log(
      value = "获取流程图的SVG",
      type = LogType.SELECT
   )
   public String selectBpmnDiagramSvg(@PathVariable Long id, @RequestParam(required = false) Long instanceId) {
      return this.extService.selectBpmnDiagramSvg(id, instanceId);
   }

   @Log(
      value = "获取工作流运行中的业务信息",
      type = LogType.SELECT
   )
   public Page<CoreBpmnTargetBean> selectBpmnRuntimeTargetList(RestJsonWrapperBean wrapper) {
      return null;
   }
}
