/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.data.annotation.ValidateDataWith;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftOrgBean;
import net.sinodawn.module.sys.bpmn.resource.CoreBpmnDraftResource;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftService;
import net.sinodawn.module.sys.bpmn.validator.CoreBpmnDraftSubmittableValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@LogModule("工作流草稿功能")
public class CoreBpmnDraftResourceImpl implements CoreBpmnDraftResource {
   @Autowired
   private CoreBpmnDraftService draftService;

   public CoreBpmnDraftService getService() {
      return this.draftService;
   }

   @Log(
      value = "新增",
      type = LogType.INSERT
   )
   public Long insert(RestJsonWrapperBean wrapper) {
      return this.getService().insert(wrapper);
   }

   @Log(
      value = "提交",
      type = LogType.UPDATE
   )
   @ValidateDataWith(CoreBpmnDraftSubmittableValidator.class)
   public void submit(@PathVariable Long id) {
      this.getService().submit(id);
   }

   @Log(
      value = "变更",
      type = LogType.INSERT
   )
   public Long insertByProcId(@PathVariable Long procId) {
      return this.getService().insertByProcId(procId);
   }

   @Log(
      value = "通过流程草稿编码查询使用部门",
      type = LogType.SELECT
   )
   public Page<CoreBpmnDraftOrgBean> selectDraftOrgPagination(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      return this.getService().selectDraftOrgPagination(id, wrapper);
   }

   @Log(
      value = "新增使用部门",
      type = LogType.INSERT
   )
   public void insertDraftOrg(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().insertDraftOrg(id, wrapper);
   }

   @Log(
      value = "删除使用部门",
      type = LogType.DELETE
   )
   public void deleteDraftOrg(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      this.getService().deleteDraftOrg(id, wrapper);
   }
}
