/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramSequenceFlowConditionDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramTaskCandidatorDTO;
import net.sinodawn.module.sys.bpmn.resource.CoreBpmnDiagramResource;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@LogModule("工作流图表功能")
public class CoreBpmnDiagramResourceImpl implements CoreBpmnDiagramResource {
   @Autowired
   private CoreBpmnDiagramService diagramService;

   public CoreBpmnDiagramService getService() {
      return this.diagramService;
   }

   public Page<CoreBpmnDiagramTaskCandidatorDTO> selectTaskCandidatorList(@PathVariable Long id) {
      return new Pagination(this.getService().selectTaskCandidatorList(id));
   }

   public Page<CoreBpmnDiagramSequenceFlowConditionDTO> selectSequenceFlowConditionList(@PathVariable Long id) {
      return new Pagination(this.getService().selectSequenceFlowConditionList(id));
   }
}
