/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/sys/bpmn-procs"})
public interface CoreBpmnProcResource extends GenericResource<CoreBpmnProcService, CoreBpmnProcBean, Long> {
   @Log(
      value = "获取流程图导入文件的地址",
      type = LogType.EXPORT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-input-url"},
      method = {RequestMethod.POST}
   )
   String getBpmnInputTextUrl(@PathVariable Long id);

   @RequestMapping(
      value = {"/{id}/bpmn-proc-orgs/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnProcOrgBean> selectProcOrgPagination(Long id, RestJsonWrapperBean wrapper);
}
