/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/sys/bpmn-inst-tasks"})
public interface CoreBpmnInstanceTaskResource extends GenericResource<CoreBpmnInstanceTaskService, CoreBpmnInstanceTaskBean, Long> {
   @Log(
      value = "查询流程执行实例的任务下的审核人员",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-inst-task-users/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnInstanceTaskUserBean> selectInstTaskUserList(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @Log(
      value = "查询流程执行实例的任务下的审核角色",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-inst-task-roles/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnInstanceTaskRoleBean> selectInstTaskRoleList(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @Log(
      value = "新增流程执行实例的任务下的审核人员",
      type = LogType.INSERT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-inst-task-users"},
      method = {RequestMethod.POST}
   )
   void insertInstTaskUser(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @Log(
      value = "新增流程执行实例的任务下的审核角色",
      type = LogType.INSERT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-inst-task-roles"},
      method = {RequestMethod.POST}
   )
   void insertInstTaskRole(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @Log(
      value = "删除流程执行实例的任务下的审核人员",
      type = LogType.INSERT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-inst-task-users"},
      method = {RequestMethod.DELETE}
   )
   void deleteInstTaskUser(@PathVariable Long id, RestJsonWrapperBean wrapper);

   @Log(
      value = "删除流程执行实例的任务下的审核角色",
      type = LogType.INSERT
   )
   @RequestMapping(
      value = {"/{id}/bpmn-inst-task-roles"},
      method = {RequestMethod.DELETE}
   )
   void deleteInstTaskRole(@PathVariable Long id, RestJsonWrapperBean wrapper);
}
