/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnRejectableTaskDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnRuntimeDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTargetBean;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping({"/secure/core/module/sys/bpmn-exts"})
public interface CoreBpmnExtResource {
   @RequestMapping(
      value = {"/runtime-info"},
      method = {RequestMethod.GET}
   )
   CoreBpmnRuntimeDTO selectBpmnRuntimeInfo(@RequestParam String table, @RequestParam String id);

   @RequestMapping(
      value = {"/options/rejectable-tasks"},
      method = {RequestMethod.POST}
   )
   List<CoreBpmnRejectableTaskDTO> selectBpmnRuntimeRejectableTaskList(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/bpmn-diagrams/{id}/svg"},
      method = {RequestMethod.GET}
   )
   String selectBpmnDiagramSvg(@PathVariable Long id, @RequestParam(required = false) Long instanceId);

   @RequestMapping(
      value = {"/runtime-targets"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnTargetBean> selectBpmnRuntimeTargetList(RestJsonWrapperBean wrapper);
}
