/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftOrgBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/sys/bpmn-drafts"})
public interface CoreBpmnDraftResource extends GenericResource<CoreBpmnDraftService, CoreBpmnDraftBean, Long> {
   @RequestMapping(
      method = {RequestMethod.POST}
   )
   Long insert(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/source-procs/{procId}"},
      method = {RequestMethod.POST}
   )
   Long insertByProcId(Long procId);

   @RequestMapping(
      value = {"/{id}/action/submit"},
      method = {RequestMethod.PUT}
   )
   void submit(Long id);

   @RequestMapping(
      value = {"/{id}/bpmn-draft-orgs/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnDraftOrgBean> selectDraftOrgPagination(Long id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/bpmn-draft-orgs"},
      method = {RequestMethod.POST}
   )
   void insertDraftOrg(Long id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/bpmn-draft-orgs"},
      method = {RequestMethod.DELETE}
   )
   void deleteDraftOrg(Long id, RestJsonWrapperBean wrapper);
}
