/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramSequenceFlowConditionDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramTaskCandidatorDTO;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/sys/bpmn-diagrams"})
public interface CoreBpmnDiagramResource extends GenericResource<CoreBpmnDiagramService, CoreBpmnDiagramBean, Long> {
   @Log(
      value = "获取流程图表中所有节点审核人员信息",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/{id}/queries/task-candidators"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnDiagramTaskCandidatorDTO> selectTaskCandidatorList(@PathVariable Long id);

   @Log(
      value = "获取流程图表中所有线中的条件信息",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/{id}/queries/sequence-flow-conditions"},
      method = {RequestMethod.POST}
   )
   Page<CoreBpmnDiagramSequenceFlowConditionDTO> selectSequenceFlowConditionList(@PathVariable Long id);
}
