/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.function;

import com.alibaba.fastjson.JSON;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileImportResultDTO;
import net.sinodawn.module.item.file.function.CoreFileImportFunction;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnImportDTO;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftService;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository("coreBpmnImportFileFunction")
public class CoreBpmnImportFileFunction implements CoreFileImportFunction {
   @Autowired
   private CoreBpmnDraftService draftService;

   public boolean test(CoreFileBean file, String service) {
      return true;
   }

   public CoreFileImportResultDTO apply(CoreFileBean coreFile) {
      Path path = CoreFileUtils.getLocalPath(coreFile);
      List<String> lineList = FileUtils.readAllLines(path.toFile());
      List<CoreBpmnImportDTO> bpmnImportList = (List)lineList.stream().filter((l) -> {
         return !StringUtils.isBlank(l);
      }).map((l) -> {
         return (CoreBpmnImportDTO)JSON.parseObject(l, CoreBpmnImportDTO.class);
      }).collect(Collectors.toList());
      this.draftService.importBpmn(bpmnImportList);
      return new CoreFileImportResultDTO();
   }
}
