/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.event;

import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import java.util.List;
import org.springframework.context.ApplicationEvent;

public class CoreBpmnNotificationEvent extends ApplicationEvent {
   private static final long serialVersionUID = -595507526485393875L;
   private ProcessStatus processStatus;
   private String desc;
   private String taskName;
   private String lastAuditorId;
   private String lastComment;
   private List<String> candidatorIdList;

   public CoreBpmnNotificationEvent(ProcessStatus processStatus, Object name, String desc, String taskName, String lastAuditorId, String lastComment, List<String> candidatorIdList) {
      super(name);
      this.desc = desc;
      this.taskName = taskName;
      this.lastAuditorId = lastAuditorId;
      this.lastComment = lastComment;
      this.candidatorIdList = candidatorIdList;
   }

   public ProcessStatus getProcessStatus() {
      return this.processStatus;
   }

   public void setProcessStatus(ProcessStatus processStatus) {
      this.processStatus = processStatus;
   }

   public String getDesc() {
      return this.desc;
   }

   public void setDesc(String desc) {
      this.desc = desc;
   }

   public String getTaskName() {
      return this.taskName;
   }

   public void setTaskName(String taskName) {
      this.taskName = taskName;
   }

   public String getLastAuditorId() {
      return this.lastAuditorId;
   }

   public void setLastAuditorId(String lastAuditorId) {
      this.lastAuditorId = lastAuditorId;
   }

   public String getLastComment() {
      return this.lastComment;
   }

   public void setLastComment(String lastComment) {
      this.lastComment = lastComment;
   }

   public List<String> getCandidatorIdList() {
      return this.candidatorIdList;
   }

   public void setCandidatorIdList(List<String> candidatorIdList) {
      this.candidatorIdList = candidatorIdList;
   }
}
