/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.support;

import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.*;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class CoreBpmnRuntimeWithdrawProcessSupport<T extends Auditable<ID>, ID extends Serializable> extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
   protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List<CoreBpmnCommentBean> commentList = this.getBpmnCommentList(sourceList);
      int i = 0;

      for(int j = sourceList.size(); i < j; ++i) {
         CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)sourceList.get(i);
         SinoConcurrentLocker.isolated(source.getTargetId());
         CoreBpmnCommentBean comment = (CoreBpmnCommentBean)commentList.stream().filter((c) -> {
            return c.getTargetId().equals(source.getTargetId());
         }).max((c1, c2) -> {
            return c1.getId().compareTo(c2.getId());
         }).orElse(null);
         if (comment == null || !comment.getStatus().equals(CommentStatus.SUBMIT.name())) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_STATUS_UPDATED");
         }
      }

   }

   protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List<CoreBpmnInstanceBean> instanceList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceList();
      List<Long> idList = (List)instanceList.stream().map((ix) -> {
         return ix.getId();
      }).collect(Collectors.toList());
      List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = this.instanceService.selectInstanceCandidatorList(idList);
      List<CoreBpmnInstanceTaskBean> taskList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTaskList();
      List<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList();
      int i = 0;

      for(int j = sourceList.size(); i < j; ++i) {
         CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)sourceList.get(i);
         CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
         source.setRuntimeInitiator(instance.getInitiator());
         source.setRuntimeProcId(instance.getProcId());
         source.setCandidatorList((List)instanceCandidatorList.stream().filter((c) -> {
            return c.getInstId().equals(instance.getId());
         }).map((c) -> {
            return c.getCandidatorId();
         }).distinct().collect(Collectors.toList()));
         List<CoreBpmnInstanceTaskBean> instanceTaskList = (List)taskList.stream().filter((t) -> {
            boolean flag = t.getInstId().equals(instance.getId());
            if (flag && !StringUtils.isEmpty(source.getCurrentStatusCode())) {
               flag = source.getCurrentStatusCode().equals(t.getStatusCode());
            }

            return flag;
         }).collect(Collectors.toList());
         Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
         StringBuilder sb = new StringBuilder();
         Iterator var14 = instanceTaskList.iterator();

         while(var14.hasNext()) {
            CoreBpmnInstanceTaskBean instanceTask = (CoreBpmnInstanceTaskBean)var14.next();
            if (sb.length() > 0) {
               sb.append(",");
            }

            Element taskElement = BpmnDiagramHelper.getProcessElement(diagram, instanceTask.getTaskId());
            sb.append(XmlUtils.getAttributeValue(taskElement, "name"));
         }

         source.setRuntimeTaskName(sb.toString());
         if (StringUtils.isEmpty(source.getComment())) {
            source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.WITHDRAW"));
         }

         String sourceName = sb.toString();
         String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.START");
         this.insertComment(source.getTargetId(), (Element)null, CommentStatus.WITHDRAW, source, this.getRoute(sourceName, targetName));
         CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
         instanceStatus.setId(source.getId());
         instanceStatus.setProcessStatus(ProcessStatus.DRAFT_WITHDRAWED);
         instanceStatusList.add(instanceStatus);
         BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(source.getTargetId());
         BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
      }

      return instanceStatusList;
   }

   private List<CoreBpmnCommentBean> getBpmnCommentList(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List<String> targetIdList = (List)sourceList.stream().map(CoreBpmnRuntimeSource::getTargetId).collect(Collectors.toList());
      return this.commentService.getDao().selectListByOneColumnValues(targetIdList, "TARGETID");
   }
}
