/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.support;

import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class CoreBpmnRuntimeUndoProcessSupport<T extends Auditable<ID>, ID extends Serializable> extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
   protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
   }

   protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList();
      int i = 0;

      for(int j = sourceList.size(); i < j; ++i) {
         CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)sourceList.get(i);
         SinoConcurrentLocker.isolated(source.getTargetId());
         if (!StringUtils.startsWithIgnoreCase(source.getOldItem().getProcessStatus(), ProcessStatus.DONE.name())) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_STATUS_UPDATED");
         }

         if (StringUtils.isEmpty(source.getComment())) {
            source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.UNDO"));
         }

         String sourceName = I18nHelper.getMessage("SINO.BPMN.TASK.END");
         String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.START");
         this.insertComment(source.getTargetId(), (Element)null, CommentStatus.UNDO, source, this.getRoute(sourceName, targetName));
         CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
         instanceStatus.setId(source.getId());
         instanceStatus.setProcessStatus(ProcessStatus.DRAFT_UNDO);
         instanceStatusList.add(instanceStatus);
      }

      return instanceStatusList;
   }
}
