/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.support;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.*;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import org.dom4j.Element;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

public class CoreBpmnRuntimeTransferProcessSupport<T extends Auditable<ID>, ID extends Serializable> extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
   protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList();
      List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceCandidatorList();
      Iterator var4 = sourceList.iterator();

      while(var4.hasNext()) {
         CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)var4.next();
         CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
         source.setRuntimeInitiator(instance.getInitiator());
         source.setRuntimeProcId(instance.getProcId());
         CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
         Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
         if (BpmnDiagramHelper.isTransferTask(taskElement)) {
            String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
            List<CoreBpmnInstanceCandidatorDTO> candidatorList = (List)instanceCandidatorList.stream().filter((c) -> {
               return instanceTask.getId().equals(c.getInstTaskId()) && LocalContextHelper.getLoginUserId().equals(c.getCandidatorId());
            }).collect(Collectors.toList());
            List<Long> taskUserIdList = (List)candidatorList.stream().filter((c) -> {
               return c.getTaskUserId() != null;
            }).map((c) -> {
               return c.getTaskUserId();
            }).collect(Collectors.toList());
            List<Long> taskRoleIdList = (List)candidatorList.stream().filter((c) -> {
               return c.getTaskRoleId() != null;
            }).map((c) -> {
               return c.getTaskRoleId();
            }).collect(Collectors.toList());
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskRoleId(taskRoleIdList);
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskUserId(taskUserIdList);
            CoreBpmnInstanceTaskUserBean taskUser = new CoreBpmnInstanceTaskUserBean();
            taskUser.setId(ApplicationContextHelper.getNextIdentity());
            taskUser.setInstId(instance.getId());
            taskUser.setInstTaskId(instanceTask.getId());
            taskUser.setUserId(source.getTransferCandidator());
            BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTaskUser(Arrays.asList(taskUser));
            this.insertComment(instance.getTargetId(), taskElement, CommentStatus.TRANSFER, source, this.getRoute(sourceName, sourceName));
         }
      }

      return instanceStatusList;
   }

   protected void validateBySql() {
   }

   protected void updateProcessStatus(String table, List<CoreBpmnInstanceStatusDTO<ID>> statusList) {
   }

   protected void doCallback(Map<String, List<ID>> callbackMap) {
   }
}
